<?php
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );
$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ) );

$randId = 'owl-' . wp_rand( 1, 10000000 );

$imgSizes = array(
	'items_3' => array( 'stm-img-635-255', 'stm-img-635-255', 'stm-img-445-540' ),
	'items_4' => array( 'stm-img-445-255', 'stm-img-635-255', 'stm-img-635-255', 'stm-img-445-255' ),
	'items_5' => array( 'stm-img-635-255', 'stm-img-445-255', 'stm-img-350-255', 'stm-img-350-255', 'stm-img-350-255' ),
);

$listings = STMMultiListing::stm_get_listings();

if ( empty( $limit ) ) {
	$limit = - 1;
}

if ( 'all' === $post_type ) {
	$post_type = array( apply_filters( 'stm_listings_post_type', 'listings' ) );
	if ( ! empty( STMMultiListing::stm_get_listing_type_slugs() ) ) {
		$post_type = array_merge( $post_type, STMMultiListing::stm_get_listing_type_slugs() );
	}
}

$args = array(
	'post_type'      => $post_type,
	'posts_per_page' => intval( $limit ),
	'post_status'    => 'publish',
	'meta_query'     => array(
		array(
			'key'     => 'special_car',
			'value'   => 'on',
			'compare' => '=',
		),
	),
);

if ( isset( $order_by ) && ! empty( $order_by ) ) {
	if ( 'popular' === $order_by ) {
		$args[] = array(
			'orderby'  => 'meta_value_num',
			'meta_key' => 'stm_car_views',
			'order'    => 'DESC',
		);
	}
}

$autoplay = $autoplay ? 'true' : 'false';

$listings = new WP_Query( $args );

$num = 0;
$i   = 0;

$imgSize = 'stm-img-398';

?>

<div class="stm-image-filter-wrap multilisting-masonry-carousel-wrap <?php echo esc_attr( $css_class ); ?>">
	<?php if ( ! empty( $title ) ) : ?>
		<div class="title">
			<h2><?php echo wp_kses_post( $title ); ?></h2>
		</div>
	<?php endif; ?>

	<?php if ( $listings->have_posts() ) : ?>

		<div id="<?php echo esc_attr( $randId ); ?>" class="owl-carousel stm-img-filter-container stm-img-<?php echo esc_attr( $row_number ); ?>">

			<?php
			while ( $listings->have_posts() ) :
				$listings->the_post();

				if ( 0 === $num ) {
					echo '<div class="carousel-container">';
				}

				if ( 3 === intval( $row_number ) && ( 0 === $num || 2 === $num ) ) {
					echo '<div class="col-wrap">';
				}
				?>

				<div class="img-filter-item template-<?php echo esc_attr( $row_number . '-' . ( $num % intval( $row_number ) ) ); ?>">
					<a href="<?php the_permalink(); ?>">
						<div class="img-wrap">
							<?php if ( has_post_thumbnail( get_the_ID() ) ) : ?>
								<?php $featured_image = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), $imgSize ); ?>
								<img
									src="<?php echo esc_url( $featured_image[0] ); ?>"
									width="<?php echo esc_attr( $featured_image[1] ); ?>"
									height="<?php echo esc_attr( $featured_image[2] ); ?>"
									alt="<?php the_title(); ?>"
									loading="lazy"
									srcset="<?php echo esc_attr( wp_get_attachment_image_srcset( get_post_thumbnail_id( get_the_ID() ), $imgSize ) ); ?>"

									<?php if ( 4 === intval( $row_number ) ) : ?>

										<?php if ( in_array( $num, array( 1, 2 ), true ) ) : ?>
											sizes="(max-width: 499px) 100vw, (max-width: 1160px) 55vw, 635px"
										<?php else : ?>
											sizes="(max-width: 499px) 100vw, (max-width: 1160px) 45vw, 445px"
										<?php endif; ?>

									<?php elseif ( 3 === intval( $row_number ) ) : ?>

										<?php if ( 2 === $num ) : ?>
											sizes="(max-width: 499px) 100vw, (max-width: 1160px) 45vw, 445px"
										<?php else : ?>
											sizes="(max-width: 499px) 100vw, (max-width: 1160px) 55vw, 635px"
										<?php endif; ?>

									<?php elseif ( 5 === intval( $row_number ) ) : ?>

										<?php if ( 0 === $num ) : ?>
											sizes="(max-width: 499px) 100vw, (max-width: 1160px) 55vw, 635px"
										<?php elseif ( 1 === $num ) : ?>
											sizes="(max-width: 499px) 100vw, (max-width: 1160px) 45vw, 445px"
										<?php else : ?>
											sizes="(max-width: 499px) 100vw, (max-width: 1160px) 33vw, 350px"
										<?php endif; ?>

									<?php endif; ?>
								/>
							<?php else : ?>
								<?php $featured_image_url = MULTILISTING_PLUGIN_URL . '/assets/img/placeholder-' . $imgSizes[ 'items_' . $row_number ][ $num ] . '.jpg'; ?>
								<img src="<?php echo esc_url( $featured_image_url ); ?>" loading="lazy" />
							<?php endif; ?>
						</div>
					</a>
					<div class="body-type-data">
						<div class="bt-title heading-font"><?php the_title(); ?></div>
						<!-- <div class="bt-count normal_font">()</div> -->
					</div>
				</div>

				<?php
				if ( 3 === intval( $row_number ) && ( 1 === $num || 2 === $num ) ) {
					echo '</div>';
				}
				$num = ( intval( $row_number ) - 1 > $num ) ? $num + 1 : 0;
				if ( 0 === $num || ( $listings->found_posts - 1 ) === $i ) {
					echo '</div>';
				}
				$i ++;
				?>

			<?php endwhile; ?>

			<?php wp_reset_postdata(); ?>

		</div>

	<?php endif; ?>
</div>

<?php
//phpcs:disable
if ( $limit != -1 && $limit <= intval( $row_number ) ) :
	?>
	<style>
        #<?php echo esc_html($randId); ?> .owl-controls {
            display: none !important;
        }
	</style>
<?php endif; ?>

<script>
    (function ($) {
        $(document).ready(function () {
            var owlIcon = $('#<?php echo esc_attr( $randId ); ?>');
            var owlRtl = false;
            if ($('body').hasClass('rtl')) {
                owlRtl = true;
            }

            owlIcon.on('initialized.owl.carousel', function (e) {
                setTimeout(function () {
                    owlIcon.find('.owl-nav, .owl-dots').wrapAll("<div class='owl-controls'></div>");
                    owlIcon.find('.owl-dots').remove();
                }, 500);
            });

            owlIcon.owlCarousel({
                items: 1,
                smartSpeed: 800,
                dots: false,
                margin: 0,
                autoplay: <?php echo $autoplay; ?>,
                nav: true,
                navElement: 'div',
                loop: true,
                responsiveRefreshRate: 1000,
            })
        });
    })(jQuery);
</script>
<?php //phpcs:enable
