<?php

namespace Motors_E_W\Pro\Widgets\SingleListing;

use Motors_E_W\MotorsApp;
use STM_E_W\Helpers\Helper;
use STM_E_W\Widgets\Controls\ContentControls\HeadingControl;
use STM_E_W\Widgets\Controls\ContentControls\SwitcherControl;
use STM_E_W\Widgets\Controls\ContentControls\NumberControl;
use Motors_E_W\Pro\Widgets\WidgetBase;

class GalleryCarouselMini extends WidgetBase {

	use SwitcherControl, NumberControl, HeadingControl;

	public function __construct( array $data = array(), array $args = null ) {
		parent::__construct( $data, $args );

		$this->stm_ew_admin_register_ss( $this->get_admin_name(), self::get_name(), MOTORS_ELEMENTOR_WIDGETS_PATH, MOTORS_ELEMENTOR_WIDGETS_URL, MOTORS_ELEMENTOR_WIDGETS_PLUGIN_VERSION );
		$this->stm_ew_enqueue(
			self::get_name(),
			MOTORS_ELEMENTOR_WIDGETS_PATH,
			MOTORS_ELEMENTOR_WIDGETS_URL,
			MOTORS_ELEMENTOR_WIDGETS_PLUGIN_VERSION,
			array(
				'jquery',
				'swiper',
				'elementor-frontend',
			)
		);
	}

	public function get_script_depends(): array {
		$depends   = parent::get_script_depends();
		$depends[] = 'swiper';

		return $depends;
	}

	public function get_style_depends(): array {
		$widget_styles   = parent::get_style_depends();
		$widget_styles[] = 'swiper';

		return $widget_styles;
	}

	public function get_categories() {
		return array( MotorsApp::WIDGET_CATEGORY_SINGLE );
	}

	public function get_name() {
		return MotorsApp::STM_PREFIX . '-single-listing-gallery-carousel-mini';
	}

	public function get_title() {
		return esc_html__( 'Gallery Carousel Mini', 'motors-elementor-widgets' );
	}

	public function get_icon() {
		return 'eicon-slider-push';
	}

	protected function register_controls() {

		$this->stm_start_content_controls_section( 'General', esc_html__( 'General', 'motors-elementor-widgets' ) );

		$this->stm_ew_add_number(
			'slides_per_view',
			array(
				'label'   => esc_html__( 'Slides Count per view', 'motors-elementor-widgets' ),
				'min'     => 2,
				'max'     => 6,
				'step'    => 1,
				'default' => 3,
			)
		);

		$this->stm_ew_add_switcher(
			'navigation',
			array(
				'label'   => esc_html__( 'Previous/Next Buttons', 'motors-elementor-widgets' ),
				'default' => 'yes',
			),
		);

		$this->stm_ew_add_number(
			'transition_speed',
			array(
				'label'       => esc_html__( 'Animation Speed', 'motors-elementor-widgets' ),
				'min'         => 100,
				'step'        => 100,
				'default'     => 400,
				'description' => esc_html__( 'Speed of slide animation in milliseconds', 'motors-elementor-widgets' ),
			)
		);

		$this->stm_ew_add_switcher(
			'autoplay',
			array(
				'label'   => esc_html__( 'Autoplay', 'motors-elementor-widgets' ),
				'default' => 'yes',
			)
		);

		$this->stm_ew_add_number(
			'delay',
			array(
				'label'       => esc_html__( 'Slide Duration', 'motors-elementor-widgets' ),
				'min'         => 100,
				'step'        => 100,
				'default'     => 3000,
				'condition'   => array(
					'autoplay' => 'yes',
				),
				'description' => esc_html__( 'Delay between transitions in milliseconds', 'motors-elementor-widgets' ),
			)
		);

		$this->stm_ew_add_switcher(
			'pause_on_mouseover',
			array(
				'label'       => esc_html__( 'Pause on Mouseover', 'motors-elementor-widgets' ),
				'condition'   => array(
					'autoplay' => 'yes',
				),
				'description' => esc_html__( 'When enabled autoplay will be paused on mouse enter over carousel container', 'motors-elementor-widgets' ),
			)
		);

		$this->stm_end_control_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		Helper::stm_ew_load_template( 'pro/widgets/single-listing/gallery-carousel-mini', MOTORS_ELEMENTOR_WIDGETS_PATH, $settings );
	}

	protected function content_template() {
	}
}
